#================= inputs =====================
data_dir="./data_for_XRTransformer/ogbn-arxiv"
embed_name="Tokenized"

X_trn=${data_dir}/Raw_text_filtered.txt # training text
X_val=${data_dir}/Raw_text.txt # valid text
 
Y_trn=${data_dir}/Y_trn.npz # training label matrix
Y_val=${data_dir}/Y_tst.npz # valid label matrix


# # Use tfidf features
X_feat_trn=${data_dir}/tfidf_feature_filtered.npz # training tfidf feature
X_feat_val=${data_dir}/tfidf_feature.npz # test tfidf feature


# # Use this if we want to skip pifa.
# L_path=${data_dir}/tfidf_feature.npz # test tfidf feature
# # Note that even with degree filtering, the number of labels is still n!!! Use the original tfidf features.

#================== outputs ====================
X_trn_pt=${data_dir}/X.${embed_name}.trn.pt # save trn tensors here
X_val_pt=${data_dir}/X.${embed_name}.val.pt # save trn tensors here
# X_tst_pt=${data_dir}/config3/X.${embed_name}.tst.pt # save tst tensors here

model_dir=${data_dir}/saved_models
embed_dir=${data_dir}/Embeddings
#==================== train ===================
python3 -m pecos.xmc.xtransformer.train \
				--trn-text-path ${X_trn} \
				--trn-feat-path ${X_feat_trn} \
				--trn-label-path ${Y_trn} \
				--model-shortcut bert-base-uncased \
				--saved-trn-pt ${X_trn_pt} \
				--tst-text-path ${X_val} \
				--tst-feat-path ${X_feat_val} \
				--tst-label-path ${Y_val} \
				--saved-val-pt ${X_val_pt} \
				--do-encoder-bootstrap \
				--model-dir ${model_dir} \
				--save-emb-dir ${embed_dir} \
				--negative-sampling tfn+man \
				--ensemble-method transformer-only \
				--nr-splits 4 \
				--max-leaf-size 100 \
				--min-codes 32 \
				--max-match-clusters 2048\
				--post-processor l3-hinge \
				--loss-function weighted-squared-hinge \
				--threshold 1e-6 \
				--max-active-matching-labels 1000 \
				--max-steps 2000 \
				--truncate-length 128 \
				--gradient-accumulation-steps 1 \
				--learning-rate 6e-5 \
				--warmup-steps 200 \
				--weight-decay 0.0 \
				--batch-size 32 \
				--logging-steps 200 \
				--save-steps 2000 \
				--beam-size 20 \
				--only-topk 5 \
				--batch-gen-workers 16 \
				--do-text-model-bootstrap \
				--verbose-level 2 \
				--force-label-embed-in-gpu \
				--seed 12345 \
				--max-pred-chunk 256 \
				|& tee ${model_dir}/train.log

# # # #==================== predict ===================
# python3 -m pecos.xmc.xtransformer.predict \
# 				--feat-path ${X_feat_tst} \
# 				--text-path ${X_tst} \
# 				--model-folder ${model_dir} \
# 				--batch-gen-workers 64 \
# 				--output-dir ${model_dir}\
# 				--batch-size 512 \
# 				--verbose-level 2 \
# 				|& tee ${model_dir}/predict.log

# python3 -m pecos.xmc.xlinear.evaluate \
# 				-y ${Y_tst} \
# 				-p ${model_dir}/P.npz \
# 				--topk 5 \
# 				|& tee ${model_dir}/result.log



# 				--label-feat-path ${L_path} \
# 				--tst-text-path ${X_val} \
# 				--tst-feat-path ${X_feat_val} \
# 				--tst-label-path ${Y_val} \
# 				--saved-val-pt ${X_val_pt} \
